#!/bin/bash

# Capability strings to set at d3f time.
# freeciv-3.2 still uses 2.6 compatible musicsets

./scripts/capabilities -c "tilespec"  -s "+Freeciv-3.2-tilespec"
./scripts/capabilities -c "soundspec" -s "+Freeciv-3.2-soundset"
./scripts/capabilities -c "musicspec" -s "+Freeciv-3.2-musicspec"
./scripts/capabilities -c "spec"      -s "+Freeciv-3.2-spec"
./scripts/capabilities -c "ruleset"   -s "+Freeciv-3.2-ruleset"

# capabilities script has no ability to handle sdl2/sdl3-client themes.
# Check also those. ( .themespec & .tspec )
# For freeciv-3.2 the .tspec capability: "+Freeciv-3.2-sdl2-spec",
# and .themespec capability: "+Freeciv-3.2-sdl2-themespec"

find data -name "*.tspec" | (while read FILE; do sed 's/+Freeciv-sdl2-spec-Devel-2022-Dec-05/+Freeciv-3.2-sdl2-spec/' $FILE > $FILE.new && mv $FILE.new $FILE ; done )
sed 's/+Freeciv-sdl2-spec-Devel-2022-Dec-05/+Freeciv-3.2-sdl2-spec/' client/gui-sdl2/themespec.c > ts.c.new && mv ts.c.new client/gui-sdl2/themespec.c
find data -name "*.themespec" | (while read FILE; do sed 's/+Freeciv-sdl2-3.2-themespec-Devel-2022-Jul-06/+Freeciv-3.2-sdl2-themespec/' $FILE > $FILE.new && mv $FILE.new $FILE ; done )
sed 's/+Freeciv-sdl2-3.2-themespec-Devel-2022-Jul-06/+Freeciv-3.2-sdl2-themespec/' client/gui-sdl2/themespec.c > ts.c.new && mv ts.c.new client/gui-sdl2/themespec.c

# Sets same capability for sdl3-client as for sdl2-client, as theme is still a shared one.
sed 's/+Freeciv-sdl2-spec-Devel-2022-Dec-05/+Freeciv-3.2-sdl2-spec/' client/gui-sdl3/themespec.c > ts.c.new && mv ts.c.new client/gui-sdl2/themespec.c
sed 's/+Freeciv-sdl2-3.2-themespec-Devel-2022-Jul-06/+Freeciv-3.2-sdl2-themespec/' client/gui-sdl3/themespec.c > ts.c.new && mv ts.c.new client/gui-sdl2/themespec.c

# capabilities script has no ability to handle modlist or mpdb capabilities
# Check also those

CAP_MODLIST_OLD="+Freeciv-modlist-Devel-3.2-2022.Jul.14"
CAP_MODLIST_NEW="+Freeciv-3.2-modlist"
CAP_MODPACK_OLD="+Freeciv-mpdl-Devel-3.2-2023.Sep.17"
CAP_MODPACK_NEW="+Freeciv-3.2-mpdl"

sed -e "s/${CAP_MODLIST_OLD}/${CAP_MODLIST_NEW}/" \
    -e "s/${CAP_MODPACK_OLD}/${CAP_MODPACK_NEW}/" tools/fcmp/download.h \
    > dl.h.new && mv dl.h.new tools/fcmp/download.h

sed -e "s/${CAP_MODLIST_OLD}/${CAP_MODLIST_NEW}/" \
    -e "s/${CAP_MODPACK_OLD}/${CAP_MODPACK_NEW}/" doc/README.modpack_installer \
    > rmi.h.new && mv rmi.h.new doc/README.modpack_installer


# capabilities script has no ability to handle modpack capabilities
# Check also those

CAP_MODPACK_OLD="+Freeciv-modpack-3.2-Devel-2021.Jun.01"
CAP_MODPACK_NEW="+Freeciv-3.2-modpack"

find data -name "*.modpack" | (while read FILE ; do sed "s/${CAP_MODPACK_OLD}/${CAP_MODPACK_NEW}/" "${FILE}" > "${FILE}.new" && mv "${FILE}.new" "${FILE}" ; done )
sed -e "s/${CAP_MODPACK_OLD}/${CAP_MODPACK_NEW}/" common/modpack.h \
    > mp.h.new && mv mp.h.new common/modpack.h
